/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.util;

import java.text.DateFormat;
import java.util.Date;
import org.apache.labs.jaxmas.registry.util.Logger;

public class DefaultLogger
implements Logger {
    public static final int LEVEL_TRACE = 5;
    public static final int LEVEL_DEBUG = 4;
    public static final int LEVEL_INFO = 3;
    public static final int LEVEL_WARN = 2;
    public static final int LEVEL_ERR = 1;
    public static final int LEVEL_NONE = 0;
    private static final String DEBUG = "DEBUG";
    private static final String ERROR = "ERROR";
    private final DateFormat df = DateFormat.getDateTimeInstance();
    private final String id;
    private int level;

    public DefaultLogger(Class<?> pClass, int pLevel) {
        this(pClass.getCanonicalName(), pLevel);
    }

    public DefaultLogger(String pId, int pLevel) {
        this.id = pId;
        this.level = pLevel;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.level >= 4;
    }

    @Override
    public boolean isErrorEnabled() {
        return this.level >= 1;
    }

    private void asString(StringBuilder pSb, Object[] pArgs) {
        if (pArgs != null) {
            for (int i = 0; i < pArgs.length; ++i) {
                if (i > 0) {
                    pSb.append(", ");
                }
                pSb.append(pArgs[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder fName(String pLevel, String pName) {
        StringBuilder sb = new StringBuilder();
        DateFormat dateFormat = this.df;
        synchronized (dateFormat) {
            sb.append(this.df.format(new Date()));
        }
        sb.append(" [");
        sb.append(pLevel);
        sb.append(',');
        sb.append(Thread.currentThread().getName());
        sb.append("] ");
        sb.append(this.id);
        sb.append(' ');
        sb.append(pName);
        return sb;
    }

    @Override
    public void entering(String pName) {
        if (this.isDebugEnabled()) {
            System.err.println(this.fName(DEBUG, pName).append(": ->"));
        }
    }

    @Override
    public void entering(String pName, String pMsg) {
        if (this.isDebugEnabled()) {
            System.err.println(this.fName(DEBUG, pName).append(": -> ").append(pMsg));
        }
    }

    @Override
    public void entering(String pName, String pMsg, Object ... pArgs) {
        if (this.isDebugEnabled()) {
            StringBuilder sb = this.fName(DEBUG, pName).append(": -> ").append(pMsg);
            this.asString(sb, pArgs);
            System.err.println(sb);
        }
    }

    @Override
    public void exiting(String pName) {
        if (this.isDebugEnabled()) {
            System.err.println(this.fName(DEBUG, pName).append(": <-"));
        }
    }

    @Override
    public void exiting(String pName, String pMsg) {
        if (this.isDebugEnabled()) {
            System.err.println(this.fName(DEBUG, pName).append(": <- ").append(pMsg));
        }
    }

    @Override
    public void debug(String pName, String pMsg) {
        if (this.isDebugEnabled()) {
            System.err.println(this.fName(DEBUG, pName).append(": ").append(pMsg));
        }
    }

    @Override
    public void error(String pName, Throwable pThrowable) {
        if (this.isErrorEnabled()) {
            String msg = pThrowable.getMessage() == null ? pThrowable.getClass().getName() : pThrowable.getMessage();
            System.err.println(this.fName(ERROR, pName).append(": ").append(msg));
        }
    }
}

