/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.util;

import org.apache.labs.jaxmas.registry.util.DefaultLogger;
import org.apache.labs.jaxmas.registry.util.Log4jLoggerFactory;
import org.apache.labs.jaxmas.registry.util.Logger;
import org.apache.labs.jaxmas.registry.util.LoggerFactory;

public class DefaultLoggerFactory
implements LoggerFactory {
    private static LoggerFactory theInstance;
    private int level = 4;

    public static synchronized LoggerFactory getInstance() {
        return theInstance;
    }

    public static synchronized void setLoggerFactory(LoggerFactory pFactory) {
        theInstance = pFactory;
    }

    @Override
    public Logger newLogger(Class<?> pClass) {
        return new DefaultLogger(pClass, this.level);
    }

    @Override
    public Logger newLogger(String pId) {
        return new DefaultLogger(pId, this.level);
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int pLevel) {
        this.level = pLevel;
    }

    static {
        LoggerFactory lf;
        try {
            lf = new Log4jLoggerFactory();
        }
        catch (Throwable t) {
            lf = new DefaultLoggerFactory();
        }
        theInstance = lf;
    }
}

