/*
 * Decompiled with CFR 0.152.
 */
package org.apache.labs.jaxmas.registry.util;

import org.apache.labs.jaxmas.registry.util.Logger;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class Log4jLogger
implements Logger {
    private final org.apache.log4j.Logger log;

    public Log4jLogger(Class<?> pClass) {
        this.log = org.apache.log4j.Logger.getLogger(pClass);
    }

    public Log4jLogger(String pId) {
        this.log = org.apache.log4j.Logger.getLogger((String)pId);
    }

    private String asString(Object[] pParams) {
        StringBuilder sb = new StringBuilder();
        if (pParams != null) {
            for (int i = 0; i < pParams.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(pParams[i]);
            }
        }
        return sb.toString();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.log.isEnabledFor((Priority)Level.ERROR);
    }

    @Override
    public void entering(String pName) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(pName + ": ->"));
        }
    }

    @Override
    public void entering(String pName, String pMsg) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(pName + ": -> " + pMsg));
        }
    }

    @Override
    public void entering(String pName, String pMsg, Object ... pArgs) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(pName + ": -> " + pMsg + ", " + this.asString(pArgs)));
        }
    }

    @Override
    public void exiting(String pName) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(pName + ": <-"));
        }
    }

    @Override
    public void exiting(String pName, String pMsg) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(pName + ": <- " + pMsg));
        }
    }

    @Override
    public void debug(String pName, String pMsg) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(pName + ": " + pMsg));
        }
    }

    @Override
    public void error(String pName, Throwable pThrowable) {
        if (this.isErrorEnabled()) {
            String msg = pThrowable.getMessage() == null ? pThrowable.getClass().getName() : pThrowable.getMessage();
            this.log.error((Object)(pName + ": " + msg), pThrowable);
        }
    }
}

